<?php
add_action( 'init', 'prk_auto_build_taxonomy', 999 );

function prk_auto_build_taxonomy() {

  register_taxonomy('auto_build_tax','product',  array(
    'hierarchical' => true,
	 'label' => 'Auto Build',
		'show_ui' => false,
		'show_in_menu' => false,
		'show_in_nav_menus' => false,
		'show_in_quick_edit' => false,
		'show_in_rest' => false,
		'show_admin_column' => false,
    'query_var' => false,
    'rewrite' => array( 'slug' => 'auto-build' ),
  ));


  if ( term_exists( 'auto-build-term', 'auto_build_tax' ) ) return;
  wp_insert_term(
    'Auto Build',   // the term
    'auto_build_tax', // the taxonomy
    array(
        'slug'        => 'auto-build-term',
    )
);
}



add_action('template_redirect', 'prk_build_product_for_new_product', 1);
function prk_build_product_for_new_product(){


	$seller_id = get_current_user_id();
	$selling   = get_user_meta( $seller_id, 'dokan_enable_selling', true );
	if($selling == 'no') return;


	global $wp;
    $request = $wp->request;
	if($request != 'dashboard/new-product') return;




	$post_id = wp_insert_post(array (
   'post_type' => 'product',
   'post_title' => 'بدون عنوان',
   'post_status' => 'draft',
   'post_author' => $seller_id,
	));


	if( ! $post_id ) return;

	wp_set_object_terms($post_id,'auto-build-term', 'auto_build_tax' );


	/*
	update_post_meta($post_id, 'prk_auto_create_post', 'true');

	if(! $post__not_in = get_user_meta($seller_id , 'prk_auto_create_post', true) )
		$post__not_in = array();

	$post__not_in[] = $post_id;
	update_user_meta($seller_id , 'prk_auto_create_post' , $post__not_in);
	*/

	$postdata = array();
	do_action( 'dokan_new_product_added', $post_id, $postdata );

	$url = dokan_edit_product_url( $post_id );

	if ( wp_safe_redirect( $url ) ) exit;
}


//add_action('dokan_before_listing_product', 'prk_remove_auto_build_products');
add_action('dokan_dashboard_before_widgets', 'prk_remove_auto_build_products'); // در پیشخوان
add_action('dokan_settings_before_form', 'prk_remove_auto_build_products'); // در تنظمیات فروشگاه
add_action('dokan_order_inside_content', 'prk_remove_auto_build_products'); // در لیست سفارشات
function prk_remove_auto_build_products(){

	$args = array(
		'posts_per_page' => -1,
		'post_type' => 'product',
		'post_status' => 'draft',
		'author'         => get_current_user_id(),
		'tax_query'      => array(
			array(
			'taxonomy' => 'auto_build_tax',
			'field' => 'slug',
			'terms' => 'auto-build-term',
			'operator'=> 'IN'
			),
		),
	);

	$posts = get_posts($args);

	if( empty( $posts ) ) return;

	foreach ( $posts as $post )
		wp_delete_post( $post->ID, true);
}


if ( ! wp_next_scheduled( 'prk_cron_remove_all_auto_build_products' ) ) {
    wp_schedule_event( time(), 'daily', 'prk_cron_remove_all_auto_build_products' );
}
add_action( 'prk_cron_remove_all_auto_build_products', 'prk_remove_all_auto_build_products' );
function prk_remove_all_auto_build_products() {

	$args = array(
		'posts_per_page' => -1,
		'post_type' => 'product',
		'post_status' => 'draft',
		'tax_query'      => array(
			array(
			'taxonomy' => 'auto_build_tax',
			'field' => 'slug',
			'terms' => 'auto-build-term',
			'operator'=> 'IN'
			),
		),
	);

	$posts = get_posts($args);

	if( empty( $posts ) ) return;

	foreach ( $posts as $post )
		wp_delete_post( $post->ID, true);
}


    function projects_custom_number_of_posts( $query ) {

    if (! is_admin() ) return;


    if ( $query->query_vars['post_type'] == 'product'  ) {

    $taxquery = array(
        array(
            'taxonomy' => 'auto_build_tax',
            'field' => 'slug',
            'terms' => 'auto-build-term',
            'operator'=> 'NOT IN'
        )
    );

    $query->set( 'tax_query', $taxquery );
        return;
    }
}
add_action( 'pre_get_posts', 'projects_custom_number_of_posts', 1 );


add_filter('dokan_pre_product_listing_args', 'prk_remove_auto_draft_product_from_listing_product', 10, 2);
function prk_remove_auto_draft_product_from_listing_product($args, $get_data){


$args['tax_query'][] =         array(
            'taxonomy' => 'auto_build_tax',
            'field' => 'slug',
            'terms' => 'auto-build-term',
            'operator'=> 'NOT IN'
        );

/*
	$post__not_in = get_user_meta(get_current_user_id() , 'prk_auto_create_post', true);

	$args['post__not_in'] = $post__not_in;
*/
	return $args;
}



add_action('dokan_product_updated', function($post_id, $postdata){

	wp_remove_object_terms($post_id, 'auto-build-term', 'auto_build_tax');
	/*
	update_post_meta($post_id, 'prk_auto_create_post', 'false');

	$seller_id = get_current_user_id();
	$post__not_in = get_user_meta($seller_id , 'prk_auto_create_post', true);
	print_r($post__not_in);
	$key = array_search($post_id, $post__not_in);
	if ($key !== false) {
		unset($post__not_in[$key]);
	}
	update_user_meta($seller_id , 'prk_auto_create_post' , $post__not_in);
	*/
}, 10, 2);






add_action('dokan_product_edit_after_options', 'prk_set_checkbox_set_pending');
function prk_set_checkbox_set_pending($post_id){

	global $post;
	if( $post->post_status == 'draft' ){ ?>

		<div class="dokan-form-group">

            <label class="" for="set-pending">
            <input name="set-pending" value="pending"  id="set-pending" type="checkbox" >
            ارسال برای بازبینی</label>
			<p>در صورتی که مایل هستید محصول را برای بازبینی ارسال کنید حتما این گزینه را تیک بزنید در غیر اینصورت محصول در حالت پیشنویس خواهد بود و بعدا هم میتوانید محصول را ویرایش نمائید</p>
        </div>

	<?php }
}



add_filter('dokan_update_product_post_data', 'test_test_test');
function test_test_test($product_data){



	if( get_post_status($product_data['ID']) != 'draft'  ){
			$product_data['post_status'] = get_post_status($product_data['ID']);
			return $product_data;
	}



	$postdata = wp_unslash( $_POST );

	$post_status = isset( $postdata['set-pending'] ) ? 'pending' : 'draft';



	$product_data['post_status'] = $post_status;

	$user_id = get_current_user_id();
	if ( dokan_is_seller_trusted( $user_id ) && isset( $postdata['set-pending'] ) )
		$product_data['post_status'] = 'publish';

	return $product_data;
}
