<?php
/**
 * Available filters for extending Merlin WP.
 *
 * @package   Merlin WP
 * @version   @@pkg.version
 * @link      https://merlinwp.com/
 * @author    Rich Tabor, from ThemeBeans.com & the team at ProteusThemes.com
 * @copyright Copyright (c) 2018, Merlin WP of Inventionn LLC
 * @license   Licensed GPLv3 for Open Source Use
 */

/**
 * Filter the home page title from your demo content.
 * If your demo's home page title is "Home", you don't need this.
 *
 * @param string $output Home page title.
 */
function prefix_merlin_content_home_page_title( $output ) {
	return 'My front page';
}
add_filter( 'merlin_content_home_page_title', 'prefix_merlin_content_home_page_title' );

/**
 * Filter the blog page title from your demo content.
 * If your demo's blog page title is "Blog", you don't need this.
 *
 * @param string $output Index blogroll page title.
 */
function prefix_merlin_content_blog_page_title( $output ) {
	return 'Journal';
}
add_filter( 'merlin_content_blog_page_title', 'prefix_merlin_content_blog_page_title' );

/**
 * Add your widget area to unset the default widgets from.
 * If your theme's first widget area is "sidebar-1", you don't need this.
 *
 * @see https://stackoverflow.com/questions/11757461/how-to-populate-widgets-on-sidebar-on-theme-activation
 *
 * @param  array $widget_areas Arguments for the sidebars_widgets widget areas.
 * @return array of arguments to update the sidebars_widgets option.
 */
function prefix_merlin_unset_default_widgets_args( $widget_areas ) {

	$widget_areas = array(
		'sidebar-1' => array(),
	);

	return $widget_areas;
}
add_filter( 'merlin_unset_default_widgets_args', 'prefix_merlin_unset_default_widgets_args' );

/**
 * Custom content for the generated child theme's functions.php file.
 *
 * @param string $output Generated content.
 * @param string $slug Parent theme slug.
 */
function prefix_generate_child_functions_php( $output, $slug ) {

	$slug_no_hyphens = strtolower( preg_replace( '#[^a-zA-Z]#', '', $slug ) );

	$output = "
		<?php
		/**
		 * Theme functions and definitions.
		 */
		function {$slug_no_hyphens}_child_enqueue_styles() {

		    if ( SCRIPT_DEBUG ) {
		        wp_enqueue_style( '{$slug}-style' , get_template_directory_uri() . '/style.css' );
		    } else {
		        wp_enqueue_style( '{$slug}-minified-style' , get_template_directory_uri() . '/style.min.css' );
		    }

		    wp_enqueue_style( '{$slug}-child-style',
		        get_stylesheet_directory_uri() . '/style.css',
		        array( '{$slug}-style' ),
		        wp_get_theme()->get('Version')
		    );
		}

		add_action(  'wp_enqueue_scripts', '{$slug_no_hyphens}_child_enqueue_styles' );\n
	";

	// Let's remove the tabs so that it displays nicely.
	$output = trim( preg_replace( '/\t+/', '', $output ) );

	// Filterable return.
	return $output;
}
add_filter( 'merlin_generate_child_functions_php', 'prefix_generate_child_functions_php', 10, 2 );

/**
 * Define the demo import files (remote files).
 *
 * To define imports, you just have to add the following code structure,
 * with your own values to your theme (using the 'merlin_import_files' filter).
 */
function prefix_merlin_import_files() {
	return array(

		// دموی پارس کالا
		array(
			'import_file_name'           => 'پارس کالا',
			'import_file_url'            => 'https://www.parskalas.com/demo/demo/pars-content2.xml',
			'import_widget_file_url'     => 'https://www.parskalas.com/demo/demo/pars-widgets2.wie',
			'import_customizer_file_url' => 'https://www.parskalas.com/demo/demo/pars-export2.dat',

			'import_notice'              => __( 'A special note for this import.', 'your-textdomain' ),
			'preview_url'                => 'https://pars.masirwp.com/',
			'import_demo_img'                => 'https://www.parskalas.com/demo/demo/pars-demo.png',
			'import_redux'               => array(
				array(
					'file_url'    => 'https://www.parskalas.com/demo/demo/pars-options2.json',
					'option_name' => 'prk_option',
				),
		    ),
		),
		// دموی موبایل
		array(
			'import_file_name'           => 'پارس موبایل',
			'import_file_url'            => 'https://www.parskalas.com/demo/mobile/mobile-content.xml',
			'import_widget_file_url'     => 'https://www.parskalas.com/demo/mobile/mobile-widgets.wie',
			'import_customizer_file_url' => 'https://www.parskalas.com/demo/mobile/mobile-export.dat',
			'import_notice'              => __( 'A special note for this import.', 'your-textdomain' ),
			'preview_url'                => 'https://pars.masirwp.com/',
			'import_demo_img'                => 'https://www.parskalas.com/demo/mobile/mobile-demo.png',
			'import_redux'               => array(
				array(
					'file_url'    => 'https://www.parskalas.com/demo/mobile/mobile-options.json',
					'option_name' => 'prk_option',
				),
		    ),
		),

		// دموی موبایل
		array(
			'import_file_name'           => 'پارس دیجیتال',
			'import_file_url'            => 'https://www.parskalas.com/demo/digital/digital-content.xml',
			'import_widget_file_url'     => 'https://www.parskalas.com/demo/digital/digital-widgets.wie',
			'import_customizer_file_url' => 'https://www.parskalas.com/demo/digital/digital-export.dat',
			'import_notice'              => __( 'A special note for this import.', 'your-textdomain' ),
			'preview_url'                => 'https://pars.masirwp.com/',
			'import_demo_img'                => 'https://www.parskalas.com/demo/digital/digital-demo.png',
			'import_redux'               => array(
				array(
					'file_url'    => 'https://www.parskalas.com/demo/digital/digital-options.json',
					'option_name' => 'prk_option',
				),
		    ),
		),
		
		array(
			'import_file_name'           => 'پارس پلاس',
			'import_file_url'            => 'https://www.masirwp.com/demo/demo/pars-content2.xml',
			'import_widget_file_url'     => 'https://www.masirwp.com/demo/demo/pars-widgets.wie',
			'import_customizer_file_url' => 'https://www.masirwp.com/demo/demo/pars-export.dat',

			'import_notice'              => __( 'A special note for this import.', 'your-textdomain' ),
			'preview_url'                => 'https://pars.masirwp.com/',

			'import_redux'               => array(
				array(
					'file_url'    => 'https://www.example.com/merlin/redux_options.json',
					'option_name' => 'prk_option',
				),
		    ),
		),

	);
}

add_filter( 'merlin_import_files', 'prefix_merlin_import_files' );

/**
 * Execute custom code after the whole import has finished.
 */
function prefix_merlin_after_import_setup() {
	
	foreach(wp_get_nav_menus() as $menu_name){
		$menu_id =$menu_name->term_id;
		wp_update_nav_menu_item($menu_id,0,array(
		'menu-item-title' => 'پارس کالا',
		'menu-item-url' => 'https://masirwp.com',
		'menu-item-status' => 'publish',
		'menu-item-type' => 'custom', // optional
	   ));
	   }
	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'main menu pars', 'nav_menu' );

	set_theme_mod(
		'nav_menu_locations', array(
			'mega-menu' => $main_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( 'صفحه اصلی' );
	$blog_page_id  = get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'merlin_after_all_import', 'prefix_merlin_after_import_setup' );
